/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.compat.IPPortingLibCompat;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.render.renderer.PortalRenderer;

public class RendererUsingStencil
extends PortalRenderer {
    @Override
    public boolean replaceFrameBufferClearing() {
        boolean skipClearing = WorldRenderInfo.isRendering();
        if (skipClearing && WorldRenderInfo.getTopRenderInfo().doRenderSky) {
            RenderSystem.depthMask((boolean)false);
            MyRenderHelper.renderScreenTriangle(FogRendererContext.getCurrentFogColor.get());
            RenderSystem.depthMask((boolean)true);
        }
        return skipClearing;
    }

    @Override
    public void onBeforeTranslucentRendering(Matrix4f modelView) {
        this.doPortalRendering(modelView);
    }

    protected void doPortalRendering(Matrix4f modelView) {
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        client.method_16011().method_15405("render_portal_total");
        this.renderPortals(modelView);
        if (PortalRendering.isRendering()) {
            this.setStencilStateForWorldRendering();
        } else {
            this.myFinishRendering();
        }
    }

    protected void renderPortals(Matrix4f modelView) {
        List<Portal> portalsToRender = this.getPortalsToRender(modelView);
        for (Portal portal : portalsToRender) {
            this.doRenderPortal(portal, modelView);
        }
    }

    @Override
    public void onAfterTranslucentRendering(Matrix4f modelView) {
    }

    @Override
    public void onHandRenderingEnded() {
    }

    @Override
    public void prepareRendering() {
        if (!IPPortingLibCompat.getIsStencilEnabled(client.method_1522())) {
            IPPortingLibCompat.setIsStencilEnabled(client.method_1522(), true);
            if (class_310.method_29611()) {
                // empty if block
            }
        }
        client.method_1522().method_1235(false);
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        GlStateManager._enableDepthTest();
        GL11.glEnable((int)2960);
    }

    @Override
    public void finishRendering() {
    }

    private void myFinishRendering() {
        GL11.glStencilFunc((int)519, (int)2333, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glDisable((int)2960);
        GlStateManager._enableDepthTest();
    }

    protected void doRenderPortal(Portal portal, Matrix4f modelView) {
        if (RendererUsingStencil.shouldSkipRenderingInsideFuseViewPortal(portal)) {
            return;
        }
        int outerPortalStencilValue = PortalRendering.getPortalLayer();
        client.method_16011().method_15396("render_view_area");
        boolean anySamplePassed = PortalRenderInfo.renderAndDecideVisibility(portal, () -> this.renderPortalViewAreaToStencil(portal, modelView));
        client.method_16011().method_15407();
        if (!anySamplePassed) {
            this.setStencilStateForWorldRendering();
            return;
        }
        PortalRendering.pushPortalLayer(portal);
        int thisPortalStencilValue = outerPortalStencilValue + 1;
        if (!portal.isFuseView()) {
            client.method_16011().method_15396("clear_depth_of_view_area");
            this.clearDepthOfThePortalViewArea(portal);
            client.method_16011().method_15407();
        }
        this.setStencilStateForWorldRendering();
        this.renderPortalContent(portal);
        PortalRendering.popPortalLayer();
        if (!portal.isFuseView()) {
            this.restoreDepthOfPortalViewArea(portal, modelView, thisPortalStencilValue);
        }
        RendererUsingStencil.clampStencilValue(outerPortalStencilValue);
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    private void renderPortalViewAreaToStencil(Portal portal, Matrix4f modelView) {
        int outerPortalStencilValue = PortalRendering.getPortalLayer();
        GL11.glStencilFunc((int)514, (int)outerPortalStencilValue, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7682);
        GL11.glStencilMask((int)255);
        FrontClipping.updateInnerClipping(modelView);
        ViewAreaRenderer.renderPortalArea(portal, class_243.field_1353, modelView, RenderSystem.getProjectionMatrix(), true, true, true, true);
    }

    private void clearDepthOfThePortalViewArea(Portal portal) {
        GlStateManager._enableDepthTest();
        GlStateManager._depthMask((boolean)true);
        this.setStencilStateForWorldRendering();
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        int originalDepthFunc = GL11.glGetInteger((int)2932);
        GL11.glDepthFunc((int)519);
        GL11.glDepthRange((double)1.0, (double)1.0);
        MyRenderHelper.renderScreenTriangle();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthFunc((int)originalDepthFunc);
        GL11.glDepthRange((double)0.0, (double)1.0);
    }

    protected void restoreDepthOfPortalViewArea(Portal portal, Matrix4f modelView, int portalStencilValue) {
        RendererUsingStencil.setStencilLimitation(portalStencilValue);
        int originalDepthFunc = GL11.glGetInteger((int)2932);
        GL11.glDepthFunc((int)519);
        ViewAreaRenderer.renderPortalArea(portal, class_243.field_1353, modelView, RenderSystem.getProjectionMatrix(), false, false, true, true);
        GL11.glDepthFunc((int)originalDepthFunc);
    }

    public static void clampStencilValue(int maximumValue) {
        GlStateManager._depthMask((boolean)true);
        GL11.glStencilFunc((int)513, (int)maximumValue, (int)255);
        GL11.glStencilOp((int)7680, (int)7681, (int)7681);
        GL11.glDepthMask((boolean)false);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager._disableDepthTest();
        MyRenderHelper.renderScreenTriangle();
        GL11.glDepthMask((boolean)true);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._enableDepthTest();
    }

    private void setStencilStateForWorldRendering() {
        int thisPortalStencilValue = PortalRendering.getPortalLayer();
        RendererUsingStencil.setStencilLimitation(thisPortalStencilValue);
    }

    public static void setStencilLimitation(int stencilValue) {
        GL11.glStencilFunc((int)514, (int)stencilValue, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
    }

    public static boolean shouldSkipRenderingInsideFuseViewPortal(Portal portal) {
        class_243 transformedCameraPos;
        if (!PortalRendering.isRendering()) {
            return false;
        }
        Portal renderingPortal = PortalRendering.getRenderingPortal();
        if (!renderingPortal.isFuseView()) {
            return false;
        }
        class_243 cameraPos = CHelper.getCurrentCameraPos();
        return cameraPos.method_1025(transformedCameraPos = portal.transformPoint(renderingPortal.transformPoint(cameraPos))) < 0.1;
    }
}

